#ifndef PARALLAX_GLSL
#define PARALLAX_GLSL
/*
parallax.glsl
Helper function to calculate parallax on a position, given all three transform matrices
*/

vec4 Parallax(vec4 in_pos, mat4 p, mat4 v, mat4 m) {
	//Apply the model transform
	vec4 pos = m*in_pos;
	
	//Take out the camera translation to modify it with parallax
	vec4 camPos = v[3];
	
	//Apply paralax based on the Z position
	if(pos.z <= -1.0f)
		camPos.x /= -pos.z;
	else if(pos.z >= 1.0f)
		camPos.x *= pos.z;

	return p * (v * vec4(pos.xyz,0) + vec4(camPos.xyz,1));
}

#endif